﻿package {
	import flash.net.*;
	import flash.events.*;
	import flash.display.*;
	import flash.text.*;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.ui.ContextMenu;
	import flash.ui.ContextMenuItem;
	import flash.geom.ColorTransform;
	
	import com.adobe.serialization.json.*;

	public class Website extends MovieClip{
		
		//global variables:
		public static var urlActions:String = "";
		
		public var mc_iconDrag = new IconDrag();
		
		public var flagDragging:Boolean = false;
		public var typeDragging:String = "";
				
		public var centerPoint:Point;
		public var boundRect:Rectangle;
		
		public var mc_dialog:Dialog = new Dialog();
		
		public var mc_dialogConfirm:DialogConfirm = new DialogConfirm();
		public var mc_dialogItemEdit:DialogItemEdit = new DialogItemEdit();
		public var mc_dialogCategoryEdit:DialogCategoryEdit = new DialogCategoryEdit();
		public var mc_copyMoveDialog:DialogCopyMove = new DialogCopyMove();		
		public var ref:FileReference = new FileReference();
		
		//stage child elements:
		//mc_catPanel
		//mc_editPanel
		//mc_topPanel
		//mc_previewPanel
		
		//constructor:
		public function Website(){
			setContextMenu();
			
			//top panel - hide items section
			mc_topPanel.hideSection("items");
			
			//calculate center
			this.centerPoint = new Point(Math.floor((this.width)/2),Math.floor((this.height)/2));
			this.boundRect = new Rectangle(this.x,this.y,this.width,this.height);
			
			//add the icons
			this.addChild(this.mc_iconDrag);
			this.mc_iconDrag.visible = false;		
			this.mc_iconDrag.mouseEnabled = false;
			
			//add website dialogs
			this.addChild(this.mc_copyMoveDialog);
			this.mc_copyMoveDialog.visible = false;
			
			this.addChild(this.mc_dialog);
			this.mc_dialog.visible = false;
			
			this.addChild(this.mc_dialogConfirm);
			this.mc_dialogConfirm.visible = false;
			
			this.addChild(this.mc_dialogItemEdit);
			this.mc_dialogItemEdit.visible = false;
			
			this.addChild(this.mc_dialogCategoryEdit);
			this.mc_dialogCategoryEdit.visible = false;
			
			this.mc_previewPanel.visible = false;
			this.mc_editPanel.visible = false;
			
			initEvents();
			
			clearStatus();
		}
		
		//--------------------------------------------------------
		// init events
		public function initEvents(){
			
			//init category panel events:			
			this.mc_topPanel.dispatcher.addEventListener("addCategoryClick", addCategory_handler);
			this.mc_topPanel.dispatcher.addEventListener("editNameCategoryClick", editNameCategory_handler);
			this.mc_topPanel.dispatcher.addEventListener("deleteCategoryClick", deleteCategory_handler);
			this.mc_topPanel.dispatcher.addEventListener("duplicateItemClick", duplicateItem_handler);
			this.mc_topPanel.dispatcher.addEventListener("downloadItemClick", downloadItem_handler);
			this.mc_topPanel.dispatcher.addEventListener("previewItemClick", previewItem_handler);
			
			//init edit panel events
			mc_editPanel.dispatcher.addEventListener("itemUploaded", itemUploaded_handler);
			mc_editPanel.dispatcher.addEventListener("uploadStarted", itemUploadStarted_handler);
			
			//init website events
			this.addEventListener(MouseEvent.MOUSE_MOVE,mouseMoveHandler);
			this.addEventListener(MouseEvent.MOUSE_UP,mouseUpHandler);
		}
		
		//--------------------------------------------------------
		// restart the website
		public function restart(){
			this.mc_previewPanel.visible = false;
			this.mc_editPanel.visible = false;
			
			hideAllDialogs();
			this.mc_editPanel.restart();
			this.mc_catPanel.restart();
			this.mc_topPanel.reset();
			this.mc_topPanel.hideSection("items");
			this.mc_topPanel.enableCategorySelectedButtons(false);
			
			setStatus("Preparing categories list...");
			refreshCategoriesList("");
		}
		
		//--------------------------------------------------------
		// set context menu for website object
		public function setContextMenu(){
			var menu:ContextMenu = new ContextMenu();
						
			menu.hideBuiltInItems();
			this.contextMenu = menu;
		}
		
		//--------------------------------------------------------
		// takes an actions url, and init all configuration.
		public function initSite(urlActions:String){
			mc_editPanel.initPanel(urlActions);	//pass upload ur as urlActions too.
		}
		
		//--------------------------------------------------------
		//show the dialog on the screen.
		public function showDialog(type:String,caption:String,text:String){						
			mc_dialog.show(type,caption,text);
		}
		
		//--------------------------------------------------------
		//show the confirmation dialog on the screen.
		public function showConfirmDialog(type:String,text:String){
			mc_dialogConfirm.show(type,text);
			this.mc_editPanel.mouseChildren = false;
			this.mc_catPanel.mouseChildren = false;
		}
		
		//--------------------------------------------------------
		// show confirm dialog to store data
		public function showConfirmDialogStoreData(type:String,text:String,tempData:String){
			mc_dialogConfirm.storeTempData(tempData);
			mc_dialogConfirm.show(type,text);
			this.mc_editPanel.mouseChildren = false;
			this.mc_catPanel.mouseChildren = false;			
		}
		
		//--------------------------------------------------------
		//show copy or move question dialog near selected category when moving items.
		public function showCopyMoveDialog(){
			mc_copyMoveDialog.show();
			mc_copyMoveDialog.x = this.mouseX+5;
			mc_copyMoveDialog.y = this.mouseY+5;
		}
				
		//--------------------------------------------------------
		//show the item edit dialog.
		public function showItemEditDialog(itemID:String,itemName:String,itemDesc:String,itemLink:String){
			this.mc_dialogItemEdit.show(itemID,itemName,itemDesc,itemLink);
		}
		
		//--------------------------------------------------------
		// show the dialog edit category
		public function showEditCategoryDialog(objCategoryData){
			this.mc_dialogCategoryEdit.show(objCategoryData);
		}
		
		//--------------------------------------------------------
		//do some operations according the type and action.
		public function confirmDialogCallback(type:String,action:Boolean){
			this.mc_editPanel.mouseChildren = true;
			this.mc_catPanel.mouseChildren = true;
			switch(type){
				case "deleteItems":
					mc_editPanel.deleteDialogCallback(action);
				break;
				case "deleteSingleItem":
					if(action == false) return(false);
					var itemID:String = mc_dialogConfirm.getTempData();
					deleteCategoryItems(itemID);
				break;
				case "deleteCategory":
					if(action == false) return(false);
					var categoryID:String = mc_dialogConfirm.getTempData();
					deleteCategory(categoryID);
				break;
				default:
					trace("confirmDialogCallback error - type don't found: "+type);
				break;
			}
		}
		
		//--------------------------------------------------------
		//hide all dialogs
		public function hideAllDialogs(){
			mc_dialogConfirm.visible = false;
			mc_dialog.visible = false;
		}
		
		//--------------------------------------------------------
		// start dragging icon near the cursor. can replace the cursor if needed
		public function startDragIcon(type:String,replace:Boolean){
			this.typeDragging = type;
			this.flagDragging = true;
			switch(type){
				case "dragHolder":
					this.mc_iconDrag.startDrag(true);
					this.mc_iconDrag.gotoAndStop(4);	//no image viewble
					this.mc_iconDrag.visible = true;
				break;
				default:
					trace(type);
				break;
			}			
		}
		
		//--------------------------------------------------------
		// change the type of dragging icon
		public function changeDragIcon(iconType){
			switch(iconType){
				case "orderable":
					this.mc_iconDrag.gotoAndStop(1);
				break;
				case "not_orderable":
					this.mc_iconDrag.gotoAndStop(2);
				break;
			}
		}
		
		//--------------------------------------------------------
		// dispatch stop dragging events to childs
		private function dispatchStopDraggingEvents(){
			switch(this.typeDragging){
				case "dragHolder":					
					mc_editPanel.mc_holder.stopDragMode();
					mc_catPanel.checkItemDragToCategory();
				break;				
				default:
					trace("can't stop dragging. wrong dragging mode");
				break;
			}
		}
		
		//--------------------------------------------------------
		// mouse up on website. check dragging operations, and stop dragging.
		private function mouseUpHandler(event:MouseEvent){
			if(this.flagDragging == false) return(false);
			
			switch(this.typeDragging){
				case "dragHolder":
					this.mc_iconDrag.stopDrag();
					this.mc_iconDrag.visible = false;
				break;
				default:
					trace("mouseUpHandler: " + this.typeDragging);
				break;
			}
			this.flagDragging = false;
			dispatchStopDraggingEvents();
		}
		
		//--------------------------------------------------------
		// mouse move on site. if dragging icon - dispatch event to childs.
		private function mouseMoveHandler(event:MouseEvent){
			/*
			if(this.flagDragging == false) return(false);
			switch(this.typeDragging){
				case "dragHolder":
					//send event to edit panel->moviesholder.
					mc_editPanel.mc_holder.dragingItemEvent();
				break;
				default:
					trace(this.typeDragging);
				break;				
			}
			*/
		}
		
		//--------------------------------------------------------
		//set status line in error style
		public function setStatusError(text:String){
			var main = this.parent;
			main.setStatusError(text);
		}
		
		//--------------------------------------------------------
		//sets status line
		public function setStatus(text:String){
			var main = this.parent;
			main.setStatus(text);
		}
		
		//--------------------------------------------------------
		//clear status line
		public function clearStatus(){
			var main = this.parent;
			main.clearStatus();			
		}
				
		//--------------------------------------------------------
		// show error message
		public function showErrorMessage(message:String){
			trace(message);
		}
		
		//--------------------------------------------------------
		// takes an initial settings from php
		public function serverRequest(strAction:String,vars:URLVariables){
			var mainclass = this.parent;
			mainclass.serverRequest(strAction,vars,"website");
		}
						
		//-------------------------------------------------------------------
		// update item name and description of item on edit panel.
		public function updateEditPanelItem(itemID:String,itemName:String,itemDesc:String,itemLink:String){
			this.mc_editPanel.updateItemNameDesc(itemID,itemName,itemDesc,itemLink);
		}
		
		//-------------------------------------------------------------------
		// update data of some category
		function updateCategoryItemData(catID:String,objData:Object){
			this.mc_catPanel.updateCategoryData(catID,objData);
		}
		
		//-------------------------------------------------------------------
		// call server to update category
		function updateCategory(objData:Object){
			var vars:URLVariables = new URLVariables();
			for(var index in objData) vars[index] = objData[index];			
						
			setStatus("Updating category");
			serverRequest("updateCategory",vars);
		}
		
		//-------------------------------------------------------------------
		// call server to update item name.
		public function updateItem(itemID:String,itemName:String,itemDesc:String,itemLink:String){
			var vars:URLVariables = new URLVariables();
			vars.itemID = itemID;
			vars.itemName = itemName;
			vars.itemDesc = itemDesc;
			vars.itemLink = itemLink;
			setStatus("Updating item");
			serverRequest("updateItem",vars);
		}
		
		//-------------------------------------------------------------------
		//add new category event handler. call add category request method.
		public function addCategory_handler(event:Event){
			addNewCategoryRequest();
		}
		
		//-------------------------------------------------------------------
		//edit name of current category
		public function currentCategoryEditName(){
			var catID = mc_catPanel.getSelectedCategoryID();
			if(catID == -1){
				showDialog("textonly","","Can't edit category. There is no category selected");
				return(false);
			}
			mc_catPanel.editNameSelectedCategory();
		}			
		
		//-------------------------------------------------------------------
		//edit name of category
		public function editNameCategory_handler(event:Event){
			currentCategoryEditName();
		}
		
		//-------------------------------------------------------------------
		//delte category
		public function deleteCategory_handler(event:Event){
			var catID = mc_catPanel.getSelectedCategoryID();
			if(catID == -1){
				showDialog("textonly","","Can't delete category, There is no category selected");
				return(false);
			}
			
			mc_catPanel.deleteSelectedCategory();
		}
				
		//duplicate item
		public function duplicateItem_handler(event:Event){
			this.mc_editPanel.duplicateSelectedItem();
		}
		
		//-------------------------------------------------------------------
		// preview item top panel trigger
		public function previewItem_handler(event:Event){
			this.mc_editPanel.previewSelectedItem();
		}
		
		//-------------------------------------------------------------------
		// open preview panel for previewing the item
		public function previewCategoryItem(item:ItemHolder,arrItems:Array){
			this.mc_previewPanel.show();
			this.mc_previewPanel.run(item,arrItems);
		}
		
		//--------------------------------------------------------
		//hide preview panel
		public function hidePreviewPanel(){
			this.mc_previewPanel.hide();
		}
		
		//-------------------------------------------------------------------
		// download item top panel trigger
		public function downloadItem_handler(event:Event){
			this.mc_editPanel.downloadSelectedItem();
		}				
		
		//-------------------------------------------------------------------
		//send the server request to duplicate item.
		public function duplicateItemRequest(itemID:Number){
			this.mc_previewPanel.hide();
			
			var selectedCatId = mc_catPanel.getSelectedCategoryID();
			var vars = new URLVariables();
			vars.itemID = itemID;
			vars.categoryID = selectedCatId;
			setStatus("Duplicating item...");
			serverRequest("duplicateItem",vars);
		}
		
		//-------------------------------------------------------------------
		//send the server request to download item
		public function downloadItemRequest(itemID:Number,filename:String){
			downloadItemRequest_link(itemID,filename);
		}
				
		//-------------------------------------------------------------------
		// download item request by link
		public function downloadItemRequest_link(itemID:Number,filename:String){
			//downloadItemRequest_link(itemID,filename);
			var strUrl = MainClass.urlActions;
			var req:URLRequest = new URLRequest(strUrl);
			var vars:URLVariables = new URLVariables();
			vars.clientAction = "downloadItem";
			vars.itemID = itemID;
			req.data = vars;
			
			navigateToURL(req,"_blank");
		}
		
		//-------------------------------------------------------------------
		//download item request by reference
		public function downloadItemRequest_reference(itemID:Number,filename:String){
			//set variables
			var vars = new URLVariables();
			vars.itemID = itemID;
			vars.clientAction = "downloadItem";
			
			//set request:
			var request:URLRequest = new URLRequest(MainClass.urlActions);
			request.method = URLRequestMethod.POST;
			request.data = vars;
			
			this.ref.download(request,filename);						
		}		
		
		//-------------------------------------------------------------------
		//send the server request to add a new category
		public function addNewCategoryRequest(){
			setStatus("Adding new category");
			serverRequest("addEmptyCategory",new URLVariables());
		}
		
		//-------------------------------------------------------------------
		//send the server request to add a new category
		public function deleteCategory(categoryID){
			var vars:URLVariables = new URLVariables();
			vars.categoryID = categoryID;
			setStatus("Deleting category");
			serverRequest("deleteCategory",vars);
		}
		
		//-------------------------------------------------------------------
		// save categories order
		public function saveCategoriesOrder_childCall(){
			var arrOrders:Array = mc_catPanel.getOrderArray();			
			var json:JSONEncoder = new JSONEncoder(arrOrders);
			var strJsonOrders:String = json.getString();
			
			var vars:URLVariables = new URLVariables();			
			vars.strJsonOrders = strJsonOrders;
			setStatus("Saving category order");
			serverRequest("saveCategoriesOrder",vars);
		}
						
		//--------------------------------------------------------
		// open relevant panel, and call relevant action.
		public function processSelectedCategory(categoryID:String){		
			// set appropriete view
			hideAllDialogs();
			this.mc_topPanel.reset();
			this.mc_topPanel.showSection("items");			
			this.mc_topPanel.enableCategorySelectedButtons(true);
			
			var category:Category = mc_catPanel.getCategoryById(categoryID);
			
			mc_editPanel.visible = true;
			getCategoryItems(categoryID);
		}
		
		//--------------------------------------------------------
		// get itemID's and item order with category id, and send request to save them.
		public function saveItemsOrder(){
			var vars:URLVariables = new URLVariables();
			
			//get items array:
			var arrItems:Array = mc_editPanel.getArrItems();
			// convert the array to itemID, itemOrder
			var arrItemsShort:Array = new Array;
			for(var i=0;i<arrItems.length;i++){
				var obj:Object = new Object;
				obj.itemID = arrItems[i].itemID;
				obj.itemOrder = i+1;
				arrItemsShort.push(obj);
			}
			
			var json:JSONEncoder = new JSONEncoder(arrItemsShort);
			var strJsonItems:String = json.getString();
			vars.strJsonItems = strJsonItems;			
			setStatus("saving order");
			serverRequest("setItemsOrder",vars);			
		}
		
		//--------------------------------------------------------
		// call server to get category items.
		public function getCategoryItems(categoryID){
			var vars:URLVariables = new URLVariables();
			vars.categoryID = categoryID;
			setStatus("Loading category items");
			serverRequest("getCategoryItems",vars);			
		}				
		
		//--------------------------------------------------------
		// category selected handler. open relevant panel.
		public function categorySelected_childCall(catID){
			processSelectedCategory(catID);
		}
				
		
		//--------------------------------------------------------
		// called when some items has been uploaded to imagesEditPanel. update number of uploaded files.
		public function refreshAfterAddingItems(){
			var vars:URLVariables = new URLVariables();
			vars.actionAfter = "updateCategoryItems";
			serverRequest("getCategoriesList",vars);	//update categories list with num items.
		}
		
		//--------------------------------------------------------
		//call refreshAfterAddingItems function to refresh added items to given category
		public function itemUploaded_handler(event:Event){
			refreshAfterAddingItems();
		}
		
		//--------------------------------------------------------
		// hide preview panel on upload start
		private function itemUploadStarted_handler(event:Event){
			hidePreviewPanel();			
		}
		
		//--------------------------------------------------------
		// call server to get category items that not listed in the images panel.
		public function updateCategoryItems(){
			var vars:URLVariables = new URLVariables();
			var selectedCatId = mc_catPanel.getSelectedCategoryID();
			if(selectedCatId == -1) return(false);
			var strCatItemIds = mc_editPanel.getStrItemIds();
			
			vars.strCurrentItems = strCatItemIds;
			vars.categoryID = selectedCatId;
			setStatus("Updating added items");
			serverRequest("getCategoryItemsOthers",vars);
		}
		
		//--------------------------------------------------------
		//check witch items has been removed.
		public function updateRemovedCategoryItems(){
			var vars:URLVariables = new URLVariables();
			var selectedCatId = mc_catPanel.getSelectedCategoryID();
			if(selectedCatId == -1) return(false);
			var strCatItemIds = mc_editPanel.getStrItemIds();
			
			vars.strCurrentItems = strCatItemIds;
			vars.categoryID = selectedCatId;
			setStatus("Updating moved items");
			serverRequest("getCategoryItemsRemoved",vars);
		}
		
		//--------------------------------------------------------
		//delete some items from the category.
		public function deleteCategoryItems(strItemIDs){
			var vars:URLVariables = new URLVariables();
			vars.strItemIDs = strItemIDs;
			vars.categoryID = mc_catPanel.getSelectedCategoryID();
			setStatus("Deleting items");
			serverRequest("deleteCategoryItems",vars);
		}
		
		//--------------------------------------------------------
		// copy selected items to mouseover category.
		function copyItemsToMouseOverCategory(){
			var categoryID = mc_catPanel.getCopyMoveCategoryId();
			var strSelectedItems = mc_editPanel.getSelectedItemIds();
			
			var vars:URLVariables = new URLVariables();			
			vars.categoryID = categoryID;
			vars.strSelectedItems = strSelectedItems;
			setStatus("Copying items...");
			serverRequest("copyItemsToCategory",vars);
		}		
		
		//--------------------------------------------------------
		// move items to mouse over category.
		function moveItemsToMouseOverCategory(){
			var categoryID = mc_catPanel.getCopyMoveCategoryId();
			var strSelectedItems = mc_editPanel.getSelectedItemIds();
			var vars:URLVariables = new URLVariables();			
			vars.categoryID = categoryID;
			vars.strSelectedItems = strSelectedItems;
			setStatus("Moving items...");
			serverRequest("moveItemsToCategory",vars);
		}
				
		//--------------------------------------------------------
		// refresh categories list, with or without actionAfter.
		public function refreshCategoriesList(actionAfter:String){
			var vars:URLVariables = new URLVariables()
			if(actionAfter != "") vars.actionAfter = actionAfter;
			serverRequest("getCategoriesList",vars);
		}
				
		//--------------------------------------------------------
		// gets the response from the server
		function serverResponse(xmlData:XML){
			switch(xmlData.action.toString()){
				case "getCategoriesList":
					setCategoriesList(xmlData);
				break;
				case "addEmptyCategory":
					addEmptyCategoryResponse(xmlData);
				break;
				case "deleteCategory":
					deleteCategoryResponse(xmlData);
				break;
				case "saveCategoriesOrder":
				break;
				case "getCategoryItems":
					setMoviesHolderWithItems(xmlData);
				break;
				case "getCategoryItemsOthers":
					addItemsToCategory(xmlData);
				break;
				case "deleteCategoryItems":
					removeDeletedItems(xmlData,"reduce");
				break;
				case "copyItemsToCategory":
					copyItemsResponseHandle();
				break;
				case "moveItemsToCategory":
					moveItemsToCategoryHandle();
				break;
				case "getCategoryItemsRemoved":
					removeDeletedItems(xmlData,"noreduce");
				break;
				case "duplicateItem":
					refreshAfterAddingItems();
				break;				
				case "updateCategory": //don't do nothing
					refreshCategoryTitle();
				break;
				case "updateItem":				
				case "setItemsOrder":
				break;
				default:
					trace("flash, website, action not found: "+xmlData.action);
				break;
			}
			
			//if exists action after - do the after action.
			if(xmlData.actionAfter != undefined && xmlData.actionAfter != ""){
				switch(xmlData.actionAfter.toString()){
					case "getCategoriesList":
						refreshCategoriesList("");						
					break;
					case "updateCategoryItems":	//after adding items.
						updateCategoryItems();
					break;
					case "updateRemovedCategoryItems":
						updateRemovedCategoryItems();
					break;
					default:
						trace("action after not found: "+xmlData.actionAfter);
					break;
				}
			}
			
		}
						
		//-------------------------------------------------------------------
		//sets categories panel from the list
		public function setCategoriesList(xmlData:XML){
			var categories:XMLList = xmlData.categories.children();	
			this.mc_catPanel.setCategories(categories);
			shareCategoriesList();
		}
		
		//-------------------------------------------------------------------
		//share categories list with the export panel
		public function shareCategoriesList(){
			var main = this.parent;
			var arrCats = this.mc_catPanel.getArrCategories();
		}
		
		//-------------------------------------------------------------------
		//response from the server to add a new category. send the panel the new category to add.
		public function addEmptyCategoryResponse(xmlData:XML){
			var category:XMLList = xmlData.category;			
			mc_catPanel.addNewCategory(category);
			shareCategoriesList();
		}
		
		//-------------------------------------------------------------------
		//response from the server after category delete. delete it from categories list.
		public function deleteCategoryResponse(xmlData:XML){
			var categoryID:String = xmlData.categoryID;
			this.mc_catPanel.removeCategory(categoryID);
			if(this.mc_catPanel.getNumCategories() == 0) restart();
			shareCategoriesList();
		}
		
		//-------------------------------------------------------------------
		//update items, hide preview panel and show top panel.
		public function setMoviesHolderWithItems(xmlData:XML){
			this.mc_previewPanel.hide();
			
			var listItems:XMLList = xmlData.arrItems.children();
			var selCategory = mc_catPanel.getSelectedCategory();
			var categoryID = selCategory.getID();
			var categoryTitle = selCategory.getTitle();
			
			this.mc_editPanel.setItems(listItems,categoryID,categoryTitle);
		}
		
		//-------------------------------------------------------------------
		//add some new items to category
		public function addItemsToCategory(xmlData:XML){
			var selectedCategoryId:Number = this.mc_catPanel.getSelectedCategoryID();
			if(selectedCategoryId == -1) return(false);						
			if(Number(xmlData.categoryID.toString()) != selectedCategoryId) return(false);	//if the user is located in other category, exit.
			
			var listItems:XMLList = xmlData.arrItems.children();
			this.mc_editPanel.addItems(listItems);
		}
		
		//-------------------------------------------------------------------
		//remove deleted items from holder, and update num category items.
		public function removeDeletedItems(xmlData:XML,reduceType:String){
			if(reduceType == "reduce"){
				if(xmlData.numNotDeletedItems > 0) showDialog("error","Error deleting items",xmlData.numNotDeletedItems + " items was not deleted!");
				if(xmlData.numDeletedItems == 0) return(false);
				
				this.mc_catPanel.reduceCategoryNumItems(xmlData.categoryID,xmlData.numDeletedItems);	//reduce category num items
			}
			
			var selectedCategoryId:Number = this.mc_catPanel.getSelectedCategoryID();
			if(selectedCategoryId != xmlData.categoryID) return(false);	//if user changed category in between don't remove items from the holder.
			   
			var listItems:XMLList = xmlData.arrDeletedItems.children();
			
			if(this.mc_previewPanel.isActive()){		
				this.mc_editPanel.removeItems(listItems,true);  //remove items with selecting next one
				this.mc_editPanel.previewSelectedItem();
		    }
			else{		//remove items without selecting next				
				this.mc_editPanel.removeItems(listItems,false);
			}
			
		}
		
		//-------------------------------------------------------------------
		//refresh categories list. unselect all items in holder.
		public function copyItemsResponseHandle(){
			this.mc_editPanel.unselectAllItems();
			refreshCategoriesList("");
		}
		
		//-------------------------------------------------------------------
		//move items back. refreshes the list, and deletes unused items
		public function moveItemsToCategoryHandle(){
			refreshCategoriesList("updateRemovedCategoryItems");
		}
		
		
		//--------------------------------------------------------
		// refresh category name in images edit panel (after updating name)
		public function refreshCategoryTitle(){
			var selCategory = mc_catPanel.getSelectedCategory();
			var categoryID = selCategory.getID();
			var categoryTitle = selCategory.getTitle();
			
			this.mc_editPanel.setCaptionText(categoryID,categoryTitle);
		}
		
		
	}
}